


trigger_service = 
{

-------------------------------------------------
personsNearTrigger = function(trigger_name)
calls.enter("personsNearTrigger",trigger_name)
	local trigger = Triggers[trigger_name]
	if (trigger ~= nil) then
		local shout_radius = trigger.shout_radius
		local effect_radius = trigger.effect_radius
		if ((shout_radius ~= nil) and (effect_radius ~= nil)) then
			local list = {}
			-------------------------------------------------
			local func = function(index, human)
				local dist = service.trigger2person_distance(trigger_name, human.id)
				if ((dist <= shout_radius) and (dist >= effect_radius)) then
					log(trigger_name, "see ",human.id)
					table.insert(list, human.id)
				end
			end
			-------------------------------------------------
			table.foreach(Humans, func)
calls.leave("personsNearTrigger",trigger_name)
			return list
		end
	end
calls.leave("personsNearTrigger",trigger_name)
end, 

-------------------------------------------------
personsInTrigger = function(trigger_name)
calls.enter("personsInTrigger",trigger_name)
	local trigger = Triggers[trigger_name]
	if (trigger ~= nil) then
		local effect_radius = trigger.effect_radius
		if (effect_radius ~= nil) then
			local list = {}
			-------------------------------------------------
			local func = function(index, human)
				local dist = service.trigger2person_distance(trigger_name, human.id)
				if (dist <= effect_radius) then
					log(trigger_name, "hold ",human.id)
					table.insert(list, human.id)
				end
			end
			-------------------------------------------------
			table.foreach(Humans, func)
calls.leave("personsInTrigger",trigger_name)
			return list
		end
	end
calls.leave("personsInTrigger",trigger_name)
end, 

-------------------------------------------------
personsInTNTTrigger = function(trigger_name)
calls.enter("personsInTNTTrigger",trigger_name)
	local trigger = Triggers[trigger_name]
	if (trigger ~= nil) then
		local activate_radius = trigger.activate_radius
		if (activate_radius ~= nil) then
			local list = {}
			-------------------------------------------------
			local func = function(index, human)
				local dist = service.trigger2person_distance(trigger_name, human.id)
				if (dist <= activate_radius) then
					log(trigger_name, "hold ",human.id)
					table.insert(list, human.id)
				end
			end
			-------------------------------------------------
			table.foreach(Humans, func)
calls.leave("personsInTNTTrigger",trigger_name)
			return list
		end
	end
calls.leave("personsInTNTTrigger",trigger_name)
end,

-------------------------------------------------
personsOutTrigger = function(trigger_name)
calls.enter("personsOutTrigger",trigger_name)
	local trigger = Triggers[trigger_name]
	if (trigger ~= nil) then
		local shout_radius = trigger.shout_radius
		if (shout_radius ~= nil) then
			local list = {}
			-------------------------------------------------
			local func = function(index, human)
				local dist = service.trigger2person_distance(trigger_name, human.id)
				if (dist > shout_radius) then
					log(trigger_name, "don't see ",human.id)
					table.insert(list, human.id)
				end
			end
			-------------------------------------------------
			table.foreach(Humans, func)
calls.leave("personsOutTrigger",trigger_name)
			return list
		end
	end
calls.leave("personsOutTrigger",trigger_name)
end, 

-------------------------------------------------
isSectorTriggerUsable = function(id, trigger_name, x_, y_, z_)
calls.enter("isSectorTriggerUsable",id..","..trigger_name)
	local trigger = Triggers[trigger_name]
	local dir = trigger.sector_dir
	local angle = trigger.sector_angle
	if ((dir ~= nil) and (angle ~= nil)) then
		local x = dir.x
		local y = dir.y
		local angle_half = angle / 2
		if ((x ~= nil) and (y ~= nil)) then
			local angle_dir = math.atan2(y, x)
			local angle1 = angle_dir + angle_half
			local angle2 = angle_dir - angle_half
			local ex = x_
			local ey = y_
			local ez = z_
			ex = ex - trigger.position.x
			ey = ey - trigger.position.y
			local angle3 = math.atan2(ey, ex)
calls.leave("isSectorTriggerUsable",id..","..trigger_name)
			return ((angle3 < angle1) and (angle3 > angle2))
		else
			log("main", "internal script error:  <cover>- "..trigger_name.."   ,   ")
		end
	else
		log("main", "internal script error:  <cover>- "..trigger_name.."  ,   ")
	end
calls.leave("isSectorTriggerUsable",id..","..trigger_name)
end, 
---------------------------------------------------
triggerObject = function(trigger_name)
calls.enter("triggerObject",trigger_name)
	local trigger = Triggers[trigger_name]
calls.leave("triggerObject",trigger_name)
	return trigger.objectHMG
end,
-------------------------------------------------
transferToTrigger = function(id, trigger_name)
calls.enter("transferToTrigger",id..","..trigger_name)
	local trigger = Triggers[trigger_name]
	if (trigger ~= nil) then
		local transfer_mode = trigger.transfer_mode
		if (transfer_mode == nil) then
			transfer_mode = "run"
		end
		move(id, transfer_mode, trigger.position.x, trigger.position.y, trigger.position.z, trigger.position.f)
		--addMove(id, transfer_mode, trigger.position.x, trigger.position.y, trigger.position.z, trigger.position.f)
	end
calls.leave("transferToTrigger",id..","..trigger_name)
end, 

-------------------------------------------------
standToTrigger = function(id, trigger_name, x, y, z)
calls.enter("standToTrigger",id..","..trigger_name)
	local trigger = Triggers[trigger_name]
	if (trigger ~= nil) then
		local pose_type = trigger.pose_type
		if (pose_type == nil) then
			pose_type = "stand"
		end
		pose(id, pose_type, x, y, z)
	end
calls.leave("standToTrigger",id..","..trigger_name)
end, 

-------------------------------------------------
checkPlayer = function(team)
calls.enter("checkPlayer",team)
	if (Players[team] == nil) then
		Players[team] = { score = 0, zones = {} }
	end
calls.leave("checkPlayer",team)
end, 

-------------------------------------------------
addZoneToPlayer = function(zone, team)
calls.enter("addZoneToPlayer",zone..","..team)
	trigger_service.checkPlayer(team)
	local player = Players[team]
	-------------------------------------------------
	local func = function(index, value)
		if (value == zone) then
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(player.zones, func) ~= 1) then
		table.insert(player.zones, zone)
	end
calls.leave("addZoneToPlayer",zone..","..team)
end, 

-------------------------------------------------
removeZoneFromPlayer = function(zone, team)
calls.enter("removeZoneFromPlayer",zone..","..team)
	trigger_service.checkPlayer(team)
	local player = Players[team]
	local self_index = 0
	-------------------------------------------------
	local func = function(index, value)
		if (value == zone) then
			self_index = index
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(player.zones, func) == 1) then
		table.remove(player.zones, self_index)
	end
calls.leave("removeZoneFromPlayer",zone..","..team)
end, 

-------------------------------------------------
findTriggers = function(id, trigger_type)
calls.enter("findTriggers",id)
	log(id, "start scanning triggers with type",trigger_type)
	local human = Humans[id]
	local memory = human.memory
	local memory_table = nil
	if		(trigger_type == "cover")			then
		memory.cover_triggers = {}
		memory_table = memory.cover_triggers
	elseif	(trigger_type == "shoot_position")	then
		memory.shoot_triggers = {}
		memory.in_shoot_trigger = ""
		memory_table = memory.shoot_triggers
	else
		log(id, "unknown trigger type")
calls.leave("findTriggers",id)
		return
	end
	-------------------------------------------------
	local find_func = function(name, trigger)
		if (trigger.type == trigger_type) then
			local dist = service.trigger2person_distance(name, id)
			log(id, "  ",name," ",id,"dist=",dist)
			if (dist <= trigger.shout_radius) then
				log(id, "found trigger",name)
				table.insert(memory_table, name)
			end
		end
	end
	-------------------------------------------------
	table.foreach(Triggers, find_func)
	log(id, "finish scanning triggers")
calls.leave("findTriggers",id)
end, 

-------------------------------------------------
findTriggers2 = function(id, trigger_type)
calls.enter("findTriggers2",id)
	local list = {}
	-------------------------------------------------
	local find_func = function(name, trigger)
		if (trigger.type == trigger_type) then
			local dist = service.trigger2person_distance(name, id)
			if (dist <= trigger.shout_radius) then
				table.insert(list, name)
			end
		end
	end
	-------------------------------------------------
	table.foreach(Triggers, find_func)

	table.sort(list, function(a,b) return service.trigger2person_distance(a, id)<service.trigger2person_distance(b, id) end)
calls.leave("findTriggers2",id)
	return list
end, 

-------------------------------------------------
isPersonInShootPosition = function(id)
calls.enter("isPersonInShootPosition",id)
	log(id, "isPersonInShootPosition")
	local human = Humans[id]
	local memory = human.memory
	local memory_table = memory.shoot_triggers
	memory.in_shoot_trigger = ""
	-------------------------------------------------
	local find_func = function(index, trigger_name)
		local trigger = Triggers[trigger_name]
		local dist = service.trigger2person_distance(trigger_name, id)
		if (dist <= trigger.effect_radius) then
			memory.in_shoot_trigger = trigger_name
			log(id, "found: "..trigger_name)
			return 1
		end
	end
	-------------------------------------------------
	if (table.foreach(memory_table, find_func) == 1) then
calls.leave("isPersonInShootPosition",id)
		return true
	end
calls.leave("isPersonInShootPosition",id)
	return false
end, 

-------------------------------------------------
isPersonInShootPosition2 = function(id)
calls.enter("isPersonInShootPosition2",id)
	local memory_table = trigger_service.findTriggers2(id, "shoot_position")
	-------------------------------------------------
	local find_func = function(index, trigger_name)
		local trigger = Triggers[trigger_name]
		local dist = service.trigger2person_distance(trigger_name, id)
		if (dist <= trigger.effect_radius) then
			return trigger_name
		end
	end
	-------------------------------------------------
calls.leave("isPersonInShootPosition2",id)
	return table.foreach(memory_table, find_func)
end, 
-------------------------------------------------
isPersonInHMGPosition = function(id)
calls.enter("isPersonInHMGPosition",id)
	local memory_table = trigger_service.findTriggers2(id, "HMG_position")
	-------------------------------------------------
	local find_func = function(index, trigger_name)
		local trigger = Triggers[trigger_name]
		local dist = service.trigger2person_distance(trigger_name, id)
		if (dist <= trigger.effect_radius) then
		--if (dist <= trigger.shout_radius) then
			return trigger_name
		end
	end
	-------------------------------------------------
calls.leave("isPersonInHMGPosition",id)
	return table.foreach(memory_table, find_func)
end, 
-------------------------------------------------
isPersonNearHMGPosition = function(id)
calls.enter("isPersonNearHMGPosition",id)
	local memory_table = trigger_service.findTriggers2(id, "HMG_position")
	-------------------------------------------------
	local find_func = function(index, trigger_name)
		local trigger = Triggers[trigger_name]
		local dist = service.trigger2person_distance(trigger_name, id)
		if (dist <= trigger.attract_radius) then
		--if (dist <= trigger.shout_radius) then
			return trigger_name
		end
	end
	-------------------------------------------------
calls.leave("isPersonNearHMGPosition",id)
	return table.foreach(memory_table, find_func)
end, 
-------------------------------------------------
hurt_observer = 
{
	deaths = {}, 
	hurts = {}, 
	addHurt = function(id, owner_id)
calls.enter("hurt_observer.addHurt",id..","..owner_id)
		trigger_service.hurt_observer.hurts[id] = owner_id
		local hurted_team_id = team(id)
		-------------------------------------------------
		local shout_func = function(index, value)
			if ((id ~= index) and (value.team_id == hurted_team_id)) then

				local fighter = nil
				if(isTurnBased()) then fighter=fighter_tb else fighter=fighter_rt end
				
				fighter.teammateHurted(index, id)
			end
		end
		-------------------------------------------------
		table.foreach(Humans, shout_func)
calls.leave("hurt_observer.addHurt",id..","..owner_id)
	end, 
	addDeath = function(id)
calls.enter("hurt_observer.addDeath",id)
		log("FIRING","DEAD\t--------\t",id,"\t-----------\t",time())
		trigger_service.hurt_observer.deaths[id] = time()
		local hurted_team_id = team(id)
		-------------------------------------------------
		local shout_func = function(index, value)
			if ((id ~= index) and (value.team_id == hurted_team_id)) then
				
				local fighter = nil
				if(isTurnBased()) then fighter=fighter_tb else fighter=fighter_rt end
				
				fighter.teammateDown(index, id)
			end
		end
		-------------------------------------------------
		table.foreach(Humans, shout_func)
calls.leave("hurt_observer.addDeath",id)
	end, 
	loadDeath = function(person_id, time)
calls.enter("hurt_observer.loadDeath",person_id)
		trigger_service.hurt_observer.deaths[person_id] = time
calls.leave("hurt_observer.loadDeath",person_id)
	end, 
	loadHurt = function(person_id, time)
calls.enter("hurt_observer.loadHurt",person_id)
		trigger_service.hurt_observer.hurts[person_id] = time
calls.leave("hurt_observer.loadHurt",person_id)
	end, 
}, 


-------------------------------------------------
person_observer = 
{
	enemies = {}, 
	underfire = {}, 
	shots = {}, 
	addEnemyEvent = function(person_id)
calls.enter("person_observer.addEnemyEvent",person_id)
		trigger_service.person_observer.enemies[person_id] = time()
calls.leave("person_observer.addEnemyEvent",person_id)
	end, 
	addUnderfireEvent = function(person_id)
calls.enter("person_observer.addUnderfireEvent",person_id)
		trigger_service.person_observer.underfire[person_id] = time()
calls.leave("person_observer.addUnderfireEvent",person_id)
	end, 
	addShotEvent = function(person_id)
calls.enter("person_observer.addShotEvent",person_id)
		trigger_service.person_observer.shots[person_id] = time()
calls.leave("person_observer.addShotEvent",person_id)
	end, 
	forget = function(time)
calls.enter("person_observer.forget")
		local tmp = {}
		-------------------------------------------------
		local func = function(id, value)
			if (value > (time - 5)) then
				tmp[id] = value
			end
		end
		-------------------------------------------------
		table.foreach(trigger_service.person_observer.enemies, func)
		trigger_service.person_observer.enemies = tmp
		tmp = {}
		table.foreach(trigger_service.person_observer.underfire, func)
		trigger_service.person_observer.underfire = tmp
		tmp = {}
		table.foreach(trigger_service.person_observer.shots, func)
		trigger_service.person_observer.shots = tmp
calls.leave("person_observer.forget")
	end, 
	loadEnemyEvent = function(person_id, time)
calls.enter("person_observer.loadEnemyEvent",person_id)
		trigger_service.person_observer.enemies[person_id] = time
calls.leave("person_observer.loadEnemyEvent",person_id)
	end, 
	loadUnderfireEvent = function(person_id, time)
calls.enter("person_observer.loadUnderfireEvent",person_id)
		trigger_service.person_observer.underfire[person_id] = time
calls.leave("person_observer.loadUnderfireEvent",person_id)
	end, 
	loadShotEvent = function(person_id, time)
calls.enter("person_observer.loadShotEvent",person_id)
		trigger_service.person_observer.shots[person_id] = time
calls.leave("person_observer.loadShotEvent",person_id)
	end, 
}, 

}